package gov.va.med.mhv.mrp.web.controller;

import java.io.Serializable;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.web.bean.UserProfile;
import gov.va.med.mhv.mrp.web.converter.MyGoalConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalExtensionsConverter;
import gov.va.med.mhv.mrp.web.converter.MyGoalExtensionsDTOConverter;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.webservice.MyGoalsWebService;

@ManagedBean
@RequestScoped
public class ChangeExtensionController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(ChangeExtensionController.class);

	@ManagedProperty("#{myGoalsWebServiceProxy}")
	private MyGoalsWebService myGoalsWebServiceProxy;
	
	@ManagedProperty("#{myGoalConverter}")
	private MyGoalConverter myGoalConverter;
	
	@ManagedProperty("#{myGoalExtensionsConverter}")
	private MyGoalExtensionsConverter myGoalExtensionsConverter;

	@ManagedProperty("#{myGoalExtensionsDTOConverter}")
	private MyGoalExtensionsDTOConverter myGoalExtensionsDTOConverter;
	
	@ManagedProperty("#{userProfile}")
	private UserProfile userProfile;
	
	@ManagedProperty("#{param.goalId}")
	private Long goalId;
	
	@ManagedProperty("#{param.goalExtensionId}")
	private Long goalExtensionId;
	
	private MyGoal goal = new MyGoal();
	
	private MyGoalsExtension myGoalsExtension  = new MyGoalsExtension();

	@PostConstruct
	public void postConstruct() {
		log.debug("@PostConstruct");
		log.debug(this);
		
		if ((goalId != null && goalId != 0) || (goalExtensionId != null && goalExtensionId != 0)) {
			load();
		} else {
			log.warn("Invalid parameters");
		}

	}
	
	private void load() {
		MyGoalDTO dto = myGoalsWebServiceProxy.getMyGoalById(userProfile.getUserProfileId(), goalId);

		goal = myGoalConverter.convert(dto);
		
		MyGoalsExtensionDTO extDTO = myGoalsWebServiceProxy.getMyGoalsExtension(goalExtensionId);

		myGoalsExtension = myGoalExtensionsConverter.convert(extDTO);
	}
	
	public void save() {
		boolean success = false;
		
		try {
			MyGoalsExtensionDTO myGoalsExtensionDTO = myGoalExtensionsDTOConverter.convert(myGoalsExtension);
			MyGoalsExtensionDTO result = myGoalsWebServiceProxy.addMyGoalsExtension(goalId, myGoalsExtensionDTO);
			
			if (result != null) {
				myGoalsExtension = myGoalExtensionsConverter.convert(result);
				success=true;
			}
			
		} catch (Exception e) {
			log.error(e);
		}
		
		if (!success) {
			log.debug("Save failed");
			FacesContext.getCurrentInstance().addMessage("",
					new FacesMessage(FacesMessage.SEVERITY_ERROR, "save failed", "save failed"));
		}
	}

	public Long getGoalId() {
		return goalId;
	}

	public void setGoalId(Long goalId) {
		this.goalId = goalId;
	}

	public Long getGoalExtensionId() {
		return goalExtensionId;
	}

	public void setGoalExtensionId(Long goalExtensionId) {
		this.goalExtensionId = goalExtensionId;
	}

	public MyGoal getGoal() {
		return goal;
	}

	public void setMyGoalConverter(MyGoalConverter myGoalConverter) {
		this.myGoalConverter = myGoalConverter;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public MyGoalsExtension getMyGoalsExtension() {
		return myGoalsExtension;
	}

	public void setMyGoalsWebServiceProxy(MyGoalsWebService myGoalsWebServiceProxy) {
		this.myGoalsWebServiceProxy = myGoalsWebServiceProxy;
	}

	public void setMyGoalExtensionsConverter(MyGoalExtensionsConverter myGoalExtensionsConverter) {
		this.myGoalExtensionsConverter = myGoalExtensionsConverter;
	}

	public void setMyGoalExtensionsDTOConverter(MyGoalExtensionsDTOConverter myGoalExtensionsDTOConverter) {
		this.myGoalExtensionsDTOConverter = myGoalExtensionsDTOConverter;
	}

	@Override
	public String toString() {
		return "ChangeExtensionController [myGoalsWebServiceProxy=" + myGoalsWebServiceProxy + ", myGoalConverter="
				+ myGoalConverter + ", myGoalExtensionsConverter=" + myGoalExtensionsConverter
				+ ", myGoalExtensionsDTOConverter=" + myGoalExtensionsDTOConverter + ", userProfile=" + userProfile
				+ ", goalId=" + goalId + ", goalExtensionId=" + goalExtensionId + ", goal=" + goal
				+ ", myGoalsExtension=" + myGoalsExtension + "]";
	}
	
	
}
